/*------------------------------------------------------------------------------*
 * File Name: OriginEvents.h													*
 * Creation: 09-13-2004	TD														*
 * Copyright (c) OriginLab Corp. 2004											*
 * All Rights Reserved															*
 * 																				*
 * Purpose:																		*
 *	Base classes for EventHandlers in Origin									*
 * Modification Log:															*
 *	CPY 9/30/04 USE_FIND_FUNC_TO_LOAD_WKBOOKSPLITTER							*
 *	CPY 2/26/2005 CELL_NAMED_RANGE_STYLE										*
 *	ML 3/24/2005 CONTEXT_MENU_X_FUNCS											*
 *	EJP 2005-04-11 v8.0220 QA70-7588 GRAPHOBJ_SUPPORT_XFUNC						*
 *  DG 10/10/05 v8.0315 WKS_PROPERTIES_BY_DBCLICK								*
 *	CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE									*
 *	CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER						*
 *	Jasmine 12/02/06 QA70-9171 CREATE_SCRIPT_PANEL								*
 *	Jasmine 12/29/06 QA70-9236 OC_WKS_PROP_DLG									*
 *	YuI 1/18/07 QA70-9281 OC_RANGE_BASED_ACCESS_TO_LABEL_AREA					*
 *	CPY 1/19/2007 QA70-9297 CLEAR_WKS_MENU_FROM_OC (also remove xf bar)			*
 *	CPY 1/23/2007 QA70-9297 CLEAR_WKS_MENU_MOVE_BACK_TO_RES_BASED				*
 *	Jasmine 02/01/07 GET_XF_FROM_TEMPLATE_TO_OPEN_XF_BAR						*
 *	Hong 03/31/07 v8.0594 MORE_SELECT_OPTION_FOR_CLEAR_LABEL					*
 *  SY 2007-04-11 QA70-9592 8.0599 RESULT_SHEET_CONTEXT_MENU					*
 *  Folger 04/23/07 RESIZE_HEIGHT												*
 *	CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE							*
 *	Jasmine 05/31/07 SET_PERCENT_OF_PAGE_SIZE									*
 *	Hong 06/30/07 v8.0653 FIX_RUNTIME_ERROR_COME_FROM_MATRIX					*
 *	Jasmine 07/13/07 RETURN_IF_NOT_PAGE											*
 *	Jasmine 07/13/07 LAYOUT_PAGE_IS_NOT_GRAPHPAGE								*
 *	Jasmine 07/23/07 SHOULD_USE_GRAPH_PAGE_BASE									*
 *	Jasmine 07/23/07 NOT_SHOW_SCRIPT_PANEL_IN_LAYOUT_BY_KITKIT_REQUEST			*
 *	Sim 07-23-2007 NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD							*
 *	Jasmine 08/15/07 80_NOT_SUPPORT_MATRIX_THEME								*
 *	TD 08-24-2007 QA80-10308  ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS	*
 *	Folger 11/05/07 IMPROVE_XF_DYNADLG_SHOW_CONTROL								*
 *	RVD 11/29/2007 v8.0758 WKS_STYLES_MENU_TRANSLATE							*
 *	Folger 07/15/08 QA80-11851 FIX_RUNTIME_ERROR_WHEN_OPEN_MATRIX_WINDOW_CORNER_CONTEXT_MENU
 *	Folger 11/16/09 QA81-14655 ADD_PASTE_LINK_TO_LABEL_CONTEXT_MENU				*
 *	Folger 12/15/09 QA81-14840 WKS_MENU_COMMAND_REMOVE_CELL_LINKS				*
 *	CPY 6/4/10 ORG-138-P6 SHOW_THUMBNAIL_TO_REPLACE_SCROLLBAR_CONTEXT_MENU		*
 *------------------------------------------------------------------------------*/


#ifndef _WKSEVENTS_H_
#define _WKSEVENTS_H_


#include "OriginEvents.h"
#include "MenuBase.h"




#define STR_WKBOOK_SPLITTER				"WkbookSplitter"
#define STR_MAT_BAR						"MatObjChooser"
#define STR_SCRIPT_PANEL				"ScriptPanel"	///Jasmine 12/02/06 QA70-9171 CREATE_SCRIPT_PANEL


// Edit commands
#define ID_EDIT_CLEAR                   0xE120
#define ID_EDIT_CLEAR_ALL               0xE121
#define ID_EDIT_COPY                    0xE122
#define ID_EDIT_CUT                     0xE123
#define ID_EDIT_FIND                    0xE124
#define ID_EDIT_PASTE                   0xE125
#define ID_EDIT_PASTE_LINK              0xE126
#define ID_EDIT_PASTE_SPECIAL           0xE127
#define ID_EDIT_REPEAT                  0xE128
#define ID_EDIT_REPLACE                 0xE129
#define ID_EDIT_SELECT_ALL              0xE12A
#define ID_EDIT_UNDO                    0xE12B
#define ID_EDIT_REDO                    0xE12C

///------ Folger 11/16/09 QA81-14655 ADD_PASTE_LINK_TO_LABEL_CONTEXT_MENU
#define ID_CM_PASTE_LINK_TRANSPOSE		0x8E68
///------ End ADD_PASTE_LINK_TO_LABEL_CONTEXT_MENU

///------ Folger 12/15/09 QA81-14840 WKS_MENU_COMMAND_REMOVE_CELL_LINKS
#define	ID_WKS_EDIT_REMOVE_LINK			0x8E98
///------ End WKS_MENU_COMMAND_REMOVE_CELL_LINKS

#define		WKS_SEL_WHOLE_ROWS						(WKS_SEL_ROW | WKS_SEL_RANGE)


#define		ID_WKSLAYERCTXT_SET_AS_LONG_NAME		OC_MENURANGE_BEGIN
#define		ID_WKSLAYERCTXT_SET_AS_COMMENT			(OC_MENURANGE_BEGIN + 1)
#define		ID_WKSLAYERCTXT_SET_AS_UNITS			(OC_MENURANGE_BEGIN + 2)
#define		ID_WKSLAYERCTXT_SET_AS_PARAMETER		(OC_MENURANGE_BEGIN + 3)
#define		ID_WKSLAYERCTXT_DELETE_SELECTION		(OC_MENURANGE_BEGIN + 4)
#define		ID_WKSLAYERCTXT_APPEND_TO_COMMENT		(OC_MENURANGE_BEGIN + 5)
#define		ID_WKSLAYERCTXT_INSERT_LABEL			(OC_MENURANGE_BEGIN + 6)
#define		ID_WKSLAYERCTXT_CLEAR_LABEL				(OC_MENURANGE_BEGIN + 7)

#define		ID_WKSLAYERCTXT_USER_COMMENTS			(OC_MENURANGE_BEGIN + 10)//-------- CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE

#define		IDM_CM_ADD_SHEET						(OC_MENURANGE_BEGIN+19)
#define 	IDM_CM_SHOW_WKBOOK_ORGANIZER 			(OC_MENURANGE_BEGIN+20)
/// TD 08-24-2007 QA80-10308  ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
#define 	IDM_CM_SHOW_DIALOGBAR 					(OC_MENURANGE_BEGIN+21)
/// end ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS

//-----CPY 1/19/2007 QA70-9297 CLEAR_WKS_MENU_FROM_OC
#define		IDM_CM_SHOW_XF_BAR						(OC_MENURANGE_BEGIN+23)	///Jasmine 02/01/07 GET_XF_FROM_TEMPLATE_TO_OPEN_XF_BAR
//---------CPY 1/23/2007 QA70-9297 CLEAR_WKS_MENU_MOVE_BACK_TO_RES_BASED
//#define 	IDM_CM_WKS_CLEAR						(OC_MENURANGE_BEGIN+23)
//---------
//-----
#define		IDM_CM_SHOW_SCRIPT_PANEL				(OC_MENURANGE_BEGIN+24)	///Jasmine 12/02/06 QA70-9171 CREATE_SCRIPT_PANEL
#define		IDM_CM_SHOW_M_BAR						(OC_MENURANGE_BEGIN+25)
/// TD 08-27-2007 QA80-10294 CONTEXT_TO_UNEMBED_GRAPHS
#define		IDM_CM_REMOVE_EMBEDDING					(OC_MENURANGE_BEGIN+26)
/// end CONTEXT_TO_UNEMBED_GRAPHS
/// TD 1-25-2008 QA80-10413  SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
#define		ID_WKSLAYERCTXT_SET_AS_SHORT_NAME		(OC_MENURANGE_BEGIN+27)
/// end SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA

#define 	IDM_CM_THEME_FIRST						(OC_MENURANGE_BEGIN+30)
#define 	IDM_CM_THEME_PASTE_FORMAT				IDM_CM_THEME_FIRST
#define		IDM_CM_THEME_SAVE_FORMAT				(OC_MENURANGE_BEGIN+31)
#define 	IDM_CM_THEME_COPY_COLORS				(OC_MENURANGE_BEGIN+35)
#define 	IDM_CM_THEME_COPY_FONTS					(OC_MENURANGE_BEGIN+36)
#define 	IDM_CM_THEME_COPY_ALL					(OC_MENURANGE_BEGIN+40)
#define 	IDM_CM_THEME_LAST						(OC_MENURANGE_BEGIN+45)

//---- CPY 2/26/2005 CELL_NAMED_RANGE_STYLE
#define		IDM_CM_CELL_UPDATE_STYLE_BEGIN			(OC_MENURANGE_BEGIN+50)
#define		IDM_CM_CELL_UPDATE_STYLE_END			(OC_MENURANGE_BEGIN+60)
//---- end CELL_NAMED_RANGE_STYLE
/// ML 3/24/2005 CONTEXT_MENU_X_FUNCS
#define		IDM_CM_WKS_X_FUNCS_BEGIN				(IDM_CM_CELL_UPDATE_STYLE_END + 1)
// Using a large interval, but not all ids will be used since not all the functions will be added to the menu.
// This is just so I can easily find the fucntion from the returned array, see doXFuncs()
#define		IDM_CM_WKS_X_FUNCS_END					(IDM_CM_WKS_X_FUNCS_BEGIN + 100)
/// end CONTEXT_MENU_X_FUNCS

/// end GETNTREE_TO_GENERATE_POPUP_MENUS

#define		IDM_CM_SHOW_XF_DIALOG					(OC_MENURANGE_BEGIN+101)	//------ Folger 11/05/07 IMPROVE_XF_DYNADLG_SHOW_CONTROL

enum {SIDEBAR_TOP, SIDEBAR_LEFT, SIDEBAR_RIGHT, SIDEBAR_BOTTOM};
//---- CPY 2/17/10 QA81-15124 HIDE_EDIT_FORMATTING_DLG
// putting function body in .h because this .h is not used anywhere else
static bool isShowEditFormatDlg() 
{
	double dd;LT_get_var("@WEF", &dd);if(dd < 1) return false;
	
	return true;
}
//----
class PageLayerEventsBase : public OriginEventsBase
{
	
public:
	//----- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
	/*
	//virtual 	
	virtual BOOL GetWksheet(Worksheet& wks)
	{
		return FALSE;
	}*/
	virtual BOOL GetWksheet(Datasheet& wks) {return false;}
	//----- end SHARE_WKBOOK_MATBOOK_ORGANIZER
	
	//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
protected:
	bool isSideBarShow(LPCSTR lpcszType)
	{
		Page& pg = GetPage();
		if(pg)
			return pg.GetSplitterInfo(lpcszType);
		
		return false;
	}
	void showSideBar(bool bShow, LPCSTR lpcszType, int nPercent, int nPosition)
	{
		Page& pg = GetPage();
		if(NULL == pg) return;
		if(!bShow)
			pg.SetSplitters(NULL);
		else
		{
			string	strConfig;
			switch(nPosition)
			{
			case SIDEBAR_BOTTOM:
				strConfig.Format("r{%s}r[%s]", (string)nPercent+"%",lpcszType);	///Jasmine 05/31/07 SET_PERCENT_OF_PAGE_SIZE
				break;
			case SIDEBAR_RIGHT:
				strConfig.Format("c{%s}c[%s]", (string)nPercent+"%",lpcszType);	///Jasmine 05/31/07 SET_PERCENT_OF_PAGE_SIZE
				break;				
			case SIDEBAR_TOP:
				strConfig.Format("r[%s]{%d}r",lpcszType, nPercent);
				break;
			case SIDEBAR_LEFT:
				break;
			}	
			pg.SetSplitters(strConfig);
		}
	}
	void showOrganizer(bool bShow=true) {showSideBar(bShow, STR_WKBOOK_SPLITTER, 50, SIDEBAR_BOTTOM);}
	void showScriptPanel(bool bShow = true) {showSideBar(bShow, STR_SCRIPT_PANEL, 60, SIDEBAR_RIGHT);}
	void showMatBar(bool bShow = true) {showSideBar(bShow, STR_MAT_BAR, 52, SIDEBAR_TOP);}


	virtual Page& GetPage() {return NULL;}
	bool isXFBarShown() {return isSideBarShow(STR_XF_BAR);}
	bool isOrganizerShown() {return isSideBarShow(STR_WKBOOK_SPLITTER);}
	bool isScriptPanelShown() {return isSideBarShow(STR_SCRIPT_PANEL);}
	bool isMatBarShown() {return isSideBarShow(STR_MAT_BAR);}
	/// TD 08-24-2007 QA80-10308  ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
	bool hasDialogBar(string & strClassName)
	{
		Page& pg = GetPage();
		if(pg && (EXIST_PLOT == pg.GetType()))
		{
			GraphPage gp(pg);
			strClassName = gp.Info.SYSTEM.DIALOGBAR.CLASSNAME$;
			return !strClassName.IsEmpty();
		}
		return false;
	}

	bool showDialogBar()
	{
		string strClassName;
		Page& pg = GetPage();
		if(!hasDialogBar(strClassName))
			return true;
		if(!isSideBarShow(strClassName))
		{
			GraphPage gp(pg);
			int nSize = gp.Info.SYSTEM.DIALOGBAR.SIZE;
			int nPosition = gp.Info.SYSTEM.DIALOGBAR.POSITION;
			showSideBar(true, strClassName, nSize, nPosition)
		}
		else
			pg.SetSplitters(NULL);

		return true;
	}
	/// end ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
	int AddSideBars(Menu& menu, int nPos = 0, int nAddSeparator = 0, bool bAddOrganizer=true, bool bAddScriptPanel=true)	///Jasmine 07/23/07 NOT_SHOW_SCRIPT_PANEL_IN_LAYOUT_BY_KITKIT_REQUEST
	{
		///Jasmine 07/13/07 RETURN_IF_NOT_PAGE
		Page& pg = GetPage();
		if(!pg)
			return nPos;
		if(nAddSeparator < 0)
			menu.InsertMenu(nPos++, MF_BYPOSITION | MF_SEPARATOR);
		//-----CPY 1/19/2007 QA70-9297 CLEAR_WKS_MENU_FROM_OC
		///Jasmine 02/01/07 GET_XF_FROM_TEMPLATE_TO_OPEN_XF_BAR, show xfbar menu if page has xfname
		//Page& pg = GetPage();
		//if(pg)
		///End RETURN_IF_NOT_PAGE
		{
			string strXFName = pg.Info.SYSTEM.XFUNCTION.NAME$;
			
			///---Sim 07-23-2007 NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD
			bool bShowHideControllable = true;
			//if ( page.Info.SYSTEM.XFUNCTION.WIZARD )
			Tree trXFBar;
			tree_get_binary_storage(trXFBar, pg, XF_PANEL_BINARY_STORAGE_NAME);
			if ( trXFBar.Wizard && trXFBar.Wizard.nVal > 0 )
				bShowHideControllable = false;
				
			if ( bShowHideControllable ) ///---Sim 07-23-2007 NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD
			{
			///---END NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD
				if(!strXFName.IsEmpty())
						menu.InsertMenu(nPos++, MF_BYPOSITION | (isXFBarShown()?MF_CHECKED : 0), IDM_CM_SHOW_XF_BAR, _L("Show X-Function Panel"));
			} ///---Sim 07-23-2007 NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD
		}
		///
		//------ Folger 11/05/07 IMPROVE_XF_DYNADLG_SHOW_CONTROL
		{
			int nShow = 0;
			if (page_xf_dynadlg_shown_control(pg, nShow))
			{
				menu.InsertMenu(nPos++, MF_BYPOSITION | (nShow ? MF_CHECKED : 0), IDM_CM_SHOW_XF_DIALOG, _L("Show X-Function Dialog"));
			}
		}
		//------ End IMPROVE_XF_DYNADLG_SHOW_CONTROL
		/// TD 08-24-2007 QA80-10308  ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
		string strDlgBarName;
		if(hasDialogBar(strDlgBarName))
			menu.InsertMenu(nPos++, MF_BYPOSITION | (isSideBarShow(strDlgBarName)?MF_CHECKED : 0), IDM_CM_SHOW_DIALOGBAR, _L("Show Control Bar"));
		/// end ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
		if(bAddOrganizer)	
			menu.InsertMenu(nPos++, MF_BYPOSITION | (isOrganizerShown()?MF_CHECKED : 0), IDM_CM_SHOW_WKBOOK_ORGANIZER, _L("Show Organizer"));
		if(bAddScriptPanel)///Jasmine 07/23/07 NOT_SHOW_SCRIPT_PANEL_IN_LAYOUT_BY_KITKIT_REQUEST
			menu.InsertMenu(nPos++, MF_BYPOSITION | (isScriptPanelShown()?MF_CHECKED : 0), IDM_CM_SHOW_SCRIPT_PANEL, _L("Show Script Panel"));///Jasmine 12/02/06 QA70-9171 CREATE_SCRIPT_PANEL
		if(nAddSeparator > 0)
			menu.InsertMenu(nPos++, MF_BYPOSITION | MF_SEPARATOR);
		return nPos;
	}
	virtual bool IsOCProcess(int nCmd)
	{
		/// TD 08-24-2007 QA80-10308  ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
		if(IDM_CM_SHOW_DIALOGBAR == nCmd)
		{
			return showDialogBar();
		}
		/// end ANOTHER_SYSTEM_SPLITTER_IN_PAGE_TO_CONTROL_GRAPHS
		if(IDM_CM_SHOW_WKBOOK_ORGANIZER == nCmd)
		{
			if(isOrganizerShown())
				showOrganizer(false);
			else
				showOrganizer(true);
			return true;
		}
		else if(IDM_CM_SHOW_XF_BAR == nCmd)
		{
			Page& pg = GetPage();
			if(NULL == pg)
			{
				out_str("err, should have page here");
				return true;
			}			
			if(isXFBarShown())
				show_xf_bar(pg,	SXFB_CLOSE);
			else
			{
				if(pg)
					//return show_xf_bar(pg, SXFB_OPEN_CHOOSER);	//show specified xf
					return show_xf_bar(pg, SXFB_OPEN_INDEPENDENT, pg.Info.SYSTEM.XFUNCTION.NAME$);
				else
					return error_report("no active page to show XF bar");
			}
			return true;
		}
		else if(IDM_CM_SHOW_SCRIPT_PANEL == nCmd)
		{
			if(isScriptPanelShown())
				showScriptPanel(false);
			else
				showScriptPanel(true);
			return true;
		}
		//------ Folger 11/05/07 IMPROVE_XF_DYNADLG_SHOW_CONTROL
		else if (IDM_CM_SHOW_XF_DIALOG == nCmd)
		{
			Page& pg = GetPage();
			if(NULL == pg)
			{
				error_report("err, should have page here");
				return true;
			}
			
			int nShow = 0;
			if (page_xf_dynadlg_shown_control(pg, nShow))
			{
				return page_xf_dynadlg_shown_control(pg, 1-nShow, false);
			}
		}
		//------ End IMPROVE_XF_DYNADLG_SHOW_CONTROL
		return false;
	}
	//----- end XFBAR_CONTEXT_MENU_ON_TITLE
	
	/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
	/*
	int defaultMenu(Menu& menu, int nSel, int nx, int ny = 0, bool bByPos = false)
	{
		Worksheet wks;
		if(GetWksheet(wks))
			return load_wks_default_context_menu(&menu, wks, nSel, nx, ny, bByPos);
		
		return 0;
	}
	*/
	//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
	/*
	BOOL defaultMenu(Menu& menu, int nId, int nPos)
	{
		Worksheet wks;
		if( GetWksheet(wks) )
			return load_wks_default_context_menu(&menu, wks, nId, nPos);
		
		return FALSE;
	}
	
	BOOL	defaultMenu(Menu& menu, int nSelectionType, int nx, int ny)
	{
		Worksheet wks;
		if( GetWksheet(wks) )
			return load_wks_default_context_menu(&menu, wks, nSelectionType, nx, ny);
		
		return FALSE;
	}
	*/
	/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
};

class WkSheetEventsBase : public PageLayerEventsBase
{
public:
	//virtual 
	bool SetObj(OriginObject &obj)
	{
		m_wks = obj;
		return m_wks.IsValid();
	}
	
	//virtual 
	OriginObject& GetObj() {return m_wks;} //------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE	


//----- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
/*
	//virtual 
	BOOL GetWksheet(Worksheet& wks)
	{
		wks = m_wks;
		return wks.IsValid();
	}

protected:
	
	Worksheet 		m_wks;
*/
	BOOL GetWksheet(Datasheet& wks)
	{
		wks = m_wks;
		return wks.IsValid();
	}

protected:
	
	Datasheet 		m_wks;
//----- end SHARE_WKBOOK_MATBOOK_ORGANIZER
};


class WkBookEventsBase : public PageLayerEventsBase
{
public:
	
	//virtual 
	bool SetObj(OriginObject &obj)
	{
		//m_wksBook = obj;
		//return m_wksBook.IsValid();
//----- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
//		WorksheetPage wp;
//		wp = obj;
		//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
		//Page wp;
		//wp = obj;
		m_page = obj;
		//------
//-----
		if(m_page)
			m_wksBook.Init(m_page);
		else
			return false;
		return true;
	}
	//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
	//virtual 
	OriginObject& GetObj()
	{
		return m_page;
	}
	Page& GetPage() {return m_page;}

	//------
	
	//virtual 
	BOOL GetWksheet(Datasheet& wks)
	{
		//if(m_wksBook)
		//	wks = m_wksBook.Layers();
		//
		//return wks.IsValid();
		return m_wksBook.GetWksheet(wks);
	}
	void InsertEditFormatting(Menu& menu, int nPos)
	{		
		menu.InsertMenu(nPos, MF_BYPOSITION, IDM_CM_THEME_SAVE_FORMAT, _L("Edit Formatting..."));
	}
private:
	///End CREATE_SCRIPT_PANEL
	bool processThemeCommands(int nCmd);
protected:
	bool IsOCProcess(int nCmd)
	{
		if(PageLayerEventsBase::IsOCProcess(nCmd))
			return true;

		///End CREATE_SCRIPT_PANEL
		if(IDM_CM_ADD_SHEET == nCmd)
		{
			m_wksBook.AddSheet(false);
		}
		else if(processThemeCommands(nCmd))
			return true;
		return false;
	}

protected:
	WorkBookActiveSheet	m_wksBook;
	//WorksheetPage m_wksBook;

	// temp solution, it seems I cannot get it from inside m_wksBook
	Page m_page;//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
};

class WksHeaderMenu :public MenuTree
{
	
public:
	
	WksHeaderMenu(Worksheet &wks, BOOL bLabelCtxt = FALSE)
	{
		Worksheet &wksAcc = m_wAccess;
		wksAcc = wks;
		//---- CPY 10/22/04 WKS_PROP_VIEW_AS_A_BRANCH
		//m_wAccess.GetTree(m_trMenu);
		GETN_TREE(tr)
		/// SY 2007-04-11 QA70-9592 8.0599 RESULT_SHEET_CONTEXT_MENU
		///	m_wAccess.GetTree(tr);
		m_wAccess.GetTree(tr, 0, wks.GetSystemParam(0) & WP_SHEET_HIERARCHY);
		/// end RESULT_SHEET_CONTEXT_MENU
		m_trMenu = tr.View;
		//-----
		
		if(!bLabelCtxt)
		{
			if(m_trMenu.ColLabels)
				m_trMenu.ColLabels.Remove();
		}
		createMenuFromTree();
	}
	
	
	BOOL IsHandled()
	{
		return m_wAccess.IsHandled();
	}

	virtual void Handler(uint nCmd)
	{
		m_wAccess.TogglePropertyValue(nCmd);
	}
	
	
private:

		WksAccess m_wAccess;	
	
};

///---- CPY ML 2/25/2005 CELL_NAMED_RANGE_STYLE
int	get_cell_wks_selection_named_styles(vector<string> &vstrStyles, Grid &grd, int nSel, int r1, int c1, int c2, int r2);
class GridSetNamedStylesMenu : public Menu
{
public:
	GridSetNamedStylesMenu(Grid &grid, Worksheet& wks, vector<string>& vsNamedStyles, int nCmdIDBegin)
	{
		m_grid = grid;
		m_wks = wks;
		m_vsNamedStyles = vsNamedStyles;
		m_nCmdIDBegin = nCmdIDBegin;
		for(int ii = 0; ii < vsNamedStyles.GetSize(); ii++)
		{
			/// RVD 11/29/2007 v8.0758 WKS_STYLES_MENU_TRANSLATE
			//Add(vsNamedStyles[ii], SetStyle);		
			Add(grid.TranslateNamedStyle(vsNamedStyles[ii]), SetStyle);
			/// end WKS_STYLES_MENU_TRANSLATE
		}
	}
protected:
	// this is not used, should handle in main handler
	void SetStyle(uint nCmd)
	{
		out_int("nCmd = ", nCmd - m_nCmdIDBegin);
	}

private:
	int				m_nCmdIDBegin;
	Grid 			m_grid;
	Worksheet		m_wks;
	vector<string>	m_vsNamedStyles;
};
//-----


class OC_REGISTERED OWksEvents : public WkSheetEventsBase
{
public:
	
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//bool OnContextMenu(int x, int y)
	bool OnContextMenu(int x, int y, DWORD dwCtrl = 0)
	/// end EVENT_HANDLING_ETC_FOR_OK 
	{
		if(m_wks)
		{
			//------ Folger 07/15/08 QA80-11851 FIX_RUNTIME_ERROR_WHEN_OPEN_MATRIX_WINDOW_CORNER_CONTEXT_MENU
			/*
			//---- CPY 12/3/04 QA70-6376 WKS_CORNER_NEED_BETTER_HANDLING
			if(OBE_MENU_CORNER & dwCtrl)
			{
				OWkBookEvents bookEvent;
				bookEvent.SetObj(m_wks.GetPage());
				return bookEvent.OnContextMenu(x,y, dwCtrl);
			}
			//----
			*/
			//------ End FIX_RUNTIME_ERROR_WHEN_OPEN_MATRIX_WINDOW_CORNER_CONTEXT_MENU
			Worksheet wks = m_wks;
			//------ Folger 07/15/08 QA80-11851 FIX_RUNTIME_ERROR_WHEN_OPEN_MATRIX_WINDOW_CORNER_CONTEXT_MENU
			if(OBE_MENU_CORNER & dwCtrl)
			{
				WkBookEventsBase	*pBookEvent = NULL;
				if ( wks )
					pBookEvent = new OWkBookEvents;
				else
					pBookEvent = new OMatBookEvents;		// then matrix sheet
				pBookEvent->SetObj(m_wks.GetPage());
				return pBookEvent->OnContextMenu(x,y, dwCtrl);
			}
			//------ End FIX_RUNTIME_ERROR_WHEN_OPEN_MATRIX_WINDOW_CORNER_CONTEXT_MENU
			
			/// Hong 06/30/07 v8.0653 FIX_RUNTIME_ERROR_COME_FROM_MATRIX
			if ( !wks )
				return false;
			/// end FIX_RUNTIME_ERROR_COME_FROM_MATRIX
			int	c1, c2, r1, r2;
			int	nSel = 	wks.GetSelectedRange(r1, c1, r2, c2);//m_wks.GetSelection(c1, c2, r1, r2);
			if(rowColHeaderMenu(x, y, nSel, c1, c2, r1, r2))
				return TRUE;
			
			
			Menu menu;
			/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
			//	defaultMenu(menu, nSel, x, y, true);
			
			//-------- CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE
			if(OBE_MENU_TITLE & dwCtrl)
			{
				menu.Add(_L("User Comments..."), ID_WKSLAYERCTXT_USER_COMMENTS);
				menu.Add(NULL, 0, MF_SEPARATOR);
			}
			//--------

			// I really not sure if return value to be analized here
			// so I keep it not analized
			defaultMenu(menu, nSel, x, y);
			/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
			
			/// YuI 1/18/07 QA70-9281 OC_RANGE_BASED_ACCESS_TO_LABEL_AREA
			//	BOOL 		bSelLabel 		= nSel == WKS_SEL_LABEL;
			BOOL 		bSelLabel = (nSel & WKS_SEL_LABEL) ? TRUE : FALSE;
			/// end OC_RANGE_BASED_ACCESS_TO_LABEL_AREA
			
			BOOL		bWholeLabelRows = bSelLabel && c1 < 0;
	
			if (nSel == WKS_SEL_WHOLE_ROWS || bWholeLabelRows)
				appendLabelItems(menu, !bWholeLabelRows, r1 < r2, bWholeLabelRows);
			else if(bSelLabel &&!bWholeLabelRows)
				appendLabelEdit(menu, nSel, r1, c1, r2, c2);
			/// TD 08-27-2007 QA80-10294 CONTEXT_TO_UNEMBED_GRAPHS
			DWORD dwEmbedParams = 0;
			if(r1== r2 && c1 == c2 && wks.GetEmbeddingParams(r1, c1, dwEmbedParams, bSelLabel))
			{
				menu.Add(NULL, 0, MF_SEPARATOR);
				menu.Add(_L("Remove Embedding"), IDM_CM_REMOVE_EMBEDDING);
			}
			/// end CONTEXT_TO_UNEMBED_GRAPHS
	
			appendSetStyle(menu, nSel, r1, c1, r2, c2);//---- CPY 2/26/2005 CELL_NAMED_RANGE_STYLE

			/// EJP 2005-04-11 v8.0220 QA70-7588 GRAPHOBJ_SUPPORT_XFUNC
			///	/// ML 3/24/2005 CONTEXT_MENU_X_FUNCS
			///	doXFuncs(menu, 0, nSel, r1, c1, r2, c2);			
			///	/// end CONTEXT_MENU_X_FUNCS
//---CPY 7/29/05 removed
//			InsertXFuncMenu(menu, 1, _L("Apply X-Functions"), IDM_CM_WKS_X_FUNCS_BEGIN, IDM_CM_WKS_X_FUNCS_END, IDXF_USGCTXT_WKS_SEL);
			/// end GRAPHOBJ_SUPPORT_XFUNC

			int		nCmd = menu.TrackPopupResMenu(0,  x, y, GetWindow());
			
			//---- CPY 2/26/2005 CELL_NAMED_RANGE_STYLE
			if(handleSetStyleCommands(nCmd, nSel, r1, c1, r2, c2))
				return true;
			//----
			/// ML 3/24/2005 CONTEXT_MENU_X_FUNCS
			if(0 < nCmd && doXFuncs(menu, nCmd, nSel, r1, c1, r2, c2))
				return true;
			/// end CONTEXT_MENU_X_FUNCS
			
			if (handleCommand(nCmd, nSel, r1, c1, r2, c2))
				return TRUE;
			
			m_wks.ProcessCommand(nCmd);
			return TRUE;
		}
		
		return FALSE;
	}
	
	/// TD 2-11-05 QA70-7393 ON_SEL_CHANGE_OC_GLOBAL
	virtual bool OnSelectionChange()
	{
		return FALSE;
	}
	/// end ON_SEL_CHANGE_OC_GLOBAL

	
	
private:
	bool handleCommand(int nCmd, int nSel, int r1, int c1, int r2, int c2)
	{
		Worksheet wks = m_wks;
		switch (nCmd)
		{
		case ID_WKSLAYERCTXT_SET_AS_LONG_NAME:
			wks.SetAsLabel(RCLT_LONG_NAME, -1, TRUE);
			break;
			
		/// TD 1-25-2008 QA80-10413  SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
		case ID_WKSLAYERCTXT_SET_AS_SHORT_NAME:
			SetSelectedAsShortName();
			break;
		/// end SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
		case ID_WKSLAYERCTXT_SET_AS_COMMENT:
			wks.SetAsLabel(RCLT_COMMENT, -1, TRUE);
			break;
			
		case ID_WKSLAYERCTXT_APPEND_TO_COMMENT:
			wks.SetAsLabel(RCLT_COMMENT, -1, TRUE, FALSE, TRUE);
			break;
			
		case ID_WKSLAYERCTXT_SET_AS_UNITS:
			wks.SetAsLabel(RCLT_UNIT, -1, TRUE);
			break;
			
		case ID_WKSLAYERCTXT_SET_AS_PARAMETER:
			wks.SetAsLabel(RCLT_PARAM, -1, TRUE);
			break;
			
		case ID_WKSLAYERCTXT_DELETE_SELECTION:
		/// TD 10-4-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
		//	m_wks.DeleteSelection(TRUE);
			deleteLabels(c1, c2, r1, r2);
		/// end WORKSHEET_CONTEXT_MORE_WORK
			break;
			
		/// TD 9-13-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
		case ID_WKSLAYERCTXT_INSERT_LABEL:
			insertLabel(c1, r1);
			break;
		case ID_WKSLAYERCTXT_CLEAR_LABEL:
			clearLabels(c1, c2, r1, r2);
			break;
		/// end WORKSHEET_CONTEXT_MORE_WORK
		/// TD 08-27-2007 QA80-10294 CONTEXT_TO_UNEMBED_GRAPHS
		case IDM_CM_REMOVE_EMBEDDING:
			wks.RemoveEmbedding(r1, c1, (nSel & WKS_SEL_LABEL) ? TRUE : FALSE);
			break;
		/// end CONTEXT_TO_UNEMBED_GRAPHS
		
		//-------- CPY 7/11/2006 USER_COMMENTS_ON_GRID_TABLE
		case ID_WKSLAYERCTXT_USER_COMMENTS:
			{
				Grid gg;
				gg.Attach(wks, 1); // 0 is the main sheet, 1 is the main grid = the top title area
				if(gg)
					grid_edit_user_comments(gg);
			}
			break;
		//---------	

		default:
			return FALSE;
		}
		
		return TRUE;		// handled
	}
	
	
	/// TD 10-4-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
	bool deleteLabels(int c1, int c2, int r1, int r2)
	{
		Worksheet wks = m_wks;
		//	if(clearLabels(c1, c2, r1, r2))
		//	{
		//		m_wks.HideLabelByType(TRUE, RCLT_COMMENT, TRUE);
		//	}
		wks.DeleteSelection(TRUE);
		return true;
	}
	
	/// TD 1-25-2008 QA80-10413  SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
	void SetSelectedAsShortName();
	/// end SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
	/// end WORKSHEET_CONTEXT_MORE_WORK
	/// TD 9-13-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
	bool insertLabel(int c1, int r1)
	{
		Worksheet wks = m_wks;
		for(int nType = RCLT_LONG_NAME; nType <= RCLT_PARAM; nType++)
		{
			if(!wks.IsLabelTypeShown(nType))
			{
				wks.CheckAddLabelByType(nType, r1, TRUE);
				return true;
			}
		}
		return false;
	}
	bool clearLabels(int c1, int c2, int r1, int r2)
	{
		Worksheet wks = m_wks;
		int iMax = max(0, r2);
		int iMin = max(0, r1);
		for(int ii = iMin; ii <= iMax; ii++)
			/// Hong 03/31/07 v8.0594 MORE_SELECT_OPTION_FOR_CLEAR_LABEL
			//wks.ClearLabelsContent(TRUE, 0, ii);
			wks.ClearLabelsContent(0, ii);
			/// end MORE_SELECT_OPTION_FOR_CLEAR_LABEL
		return true; 
	}
	/// end WORKSHEET_CONTEXT_MORE_WORK
	/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
	// function not needed
	/*
	int defaultMenu(Menu& menu, int nSel, int nx, int ny = 0, bool bByPos = false)
	{
		return load_wks_default_context_menu(&menu, m_wks, nSel, nx, ny, bByPos);
	}
	*/
	/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
	
	bool rowColHeaderMenu(int x, int y, int nSel, int c1, int c2, int r1, int r2)
	{
		Worksheet wks = m_wks;
		BOOL  bCol = FALSE; //1 = col header, 2 = RowHeader
		point pt(x,y);
		point ptRowCol(0,0);
		int nHitTest = wks.HitTestPoint(pt, &ptRowCol);
		
		if((nSel & WKS_SEL_ONE_COL) && (nSel & WKS_SEL_COLUMN) && // a single col heading
			oneColHeader(c1, x, y) ) 
			return true;
		
		if(nSel != 0)
			return false;
		
		//-------- CPY 12/3/04 QA70-6376 WKS_CORNER_NEED_BETTER_HANDLING
		/*
		bool bCorner = false;
		if((NXY_TOP|NXY_COL) == nHitTest && (ptRowCol.y < 0))
		{
			bCol = TRUE;
		}
		else if((NXY_LEFT|NXY_ROW) !=nHitTest || (ptRowCol.x >= 0))
		{
			int nCornerVal = ((NXY_TOP |NXY_OUT) |	(NXY_LEFT |NXY_ROW));
			
			bCorner = nCornerVal == nHitTest;
			if(!bCorner)
				return FALSE;
		}
		bool bCorner = IS_WKS_TOP_LEFT_CORNER_OUTSIDE(nHitTest);
		//---------
		/// TD 12-3-04 OLD_CORNER_MENU_REINSTATETD
		if(bCorner)
		{
			return ShowBookCtxt(OBE_MENU_CORNER, x,y);
		}
		/// end OLD_CORNER_MENU_REINSTATETD
		*/
		uint nCornerRowColBits = NXY_TOP | NXY_LEFT | NXY_ROW | NXY_COL;
		if((nHitTest & nCornerRowColBits) == nCornerRowColBits)
			return false;
	 	WksHeaderMenu wksHeaderMenu(wks);
		wksHeaderMenu.TrackPopupMenu(0,  x, y, GetWindow());
		return TRUE;
	}
	///---- CPY 2/26/2005 CELL_NAMED_RANGE_STYLE
	void appendSetStyle(Menu &menu, int nSel, int r1, int c1, int r2, int c2)
	{
		Worksheet wks = m_wks;
		Grid grd;
		grd.Attach(wks);
		if(grd)
		{
			if( grd.GetSelectedRange(r1, c1, r2, c2) )
			{
				nSel = WKS_SEL_RANGE;

				string strSelInfo;
				//strSelInfo.Format("nSel=%d, r1:r2=%d:%d, c1:c2=%d:%d", nSel, r1, r2, c1, c2);
				vector<string> vsNamedStyles;
				if (get_cell_wks_selection_named_styles(vsNamedStyles, grd, nSel, r1, c1, r2, c2) > 0)
				{
					GridSetNamedStylesMenu popupSetStyle(grd, wks, vsNamedStyles, IDM_CM_CELL_UPDATE_STYLE_BEGIN);
					menu.Add(NULL, 0, MF_SEPARATOR);
					menu.AddPopup(_L("Set Style ") + strSelInfo, popupSetStyle, IDM_CM_CELL_UPDATE_STYLE_BEGIN);
				}
				else 
				{
					// just for debug purpose
					menu.Add("No Style to set " + strSelInfo, IDM_CM_CELL_UPDATE_STYLE_BEGIN);
				}
			}
		}
	}
	//---- CPY 2/26/2005 CELL_NAMED_RANGE_STYLE
	
	bool doXFuncs(Menu &menu, int nCmdId, int nSel, int r1, int c1, int r2, int c2);/// ML 3/24/2005 CONTEXT_MENU_X_FUNCS


	
	
	// must return true if nCmd is in range to be handled
	bool handleSetStyleCommands(int nCmd, int nSel, int r1, int c1, int r2, int c2)
	{
		if(nCmd < IDM_CM_CELL_UPDATE_STYLE_BEGIN || nCmd > IDM_CM_CELL_UPDATE_STYLE_END)
			return false;
		
		Worksheet wks = m_wks;
		Grid grd;
		grd.Attach(wks);
		if(!grd)
		{
			error_report("failed to attach grid to wks");
			return true;
		}
		
		if( !grd.GetSelectedRange(r1, c1, r2, c2) )
			return true;

		nSel = WKS_SEL_RANGE;

		vector<string> vsNamedStyles;
		if (get_cell_wks_selection_named_styles(vsNamedStyles, grd, nSel, r1, c1, r2, c2) > 0)
		{
			int nIndex = nCmd - IDM_CM_CELL_UPDATE_STYLE_BEGIN;
			vector<string> vsToSet;
			vsToSet.Add(vsNamedStyles[nIndex]);
			printf("Setting wks style %s\n", vsToSet[0]);
			grd.Styles(r1, c1, r2, c2, vsToSet, false);
		}
		return true;
	}
	//----

	///--- end CELL_NAMED_RANGE_STYLE
	
	void 	appendLabelEdit(Menu &menu, int nSel, int r1, int c1, int r2, int c2)
	{
		/// YuI 1/18/07 QA70-9281 OC_RANGE_BASED_ACCESS_TO_LABEL_AREA
		//printf("nSel=%d, r1=%d, c1=%d\n", nSel, r1, c1);
		if(r1==r2)
		{
			int nLabelType = RCLT_COMMENT;
			Worksheet wks = m_wks;
			if(wks)
				nLabelType = wks.GetLabelType(r1);//CPY 1/20/2007
			if(RCLT_SPARKLINE == nLabelType)
				menu.Add(_L(""), ID_DYN_XF_WKS_CM_SPARKLINE);
			else if(c1==c2)
				menu.Add(_L(""), ID_DYN_XF_WKS_CM_LABELCELL);
		}
		/// end OC_RANGE_BASED_ACCESS_TO_LABEL_AREA

		menu.Add(_L("Cu&t"), ID_EDIT_CUT);
		menu.Add(_L("&Copy"), ID_EDIT_COPY);
		menu.Add(_L("&Paste"), ID_EDIT_PASTE);
		///------ Folger 11/16/09 QA81-14655 ADD_PASTE_LINK_TO_LABEL_CONTEXT_MENU
		menu.Add(_L("&Paste &Link\tCtrl + Alt + V"), ID_EDIT_PASTE_LINK);
		menu.Add(_L("&Paste Link Transpose"), ID_CM_PASTE_LINK_TRANSPOSE);
		///------ End ADD_PASTE_LINK_TO_LABEL_CONTEXT_MENU
		menu.Add(_L("Clea&r\tDel"), ID_EDIT_CLEAR);
		///------ Folger 12/15/09 QA81-14840 WKS_MENU_COMMAND_REMOVE_CELL_LINKS
		menu.Add(_L("Remo&ve Link"), ID_WKS_EDIT_REMOVE_LINK);
		///------ End WKS_MENU_COMMAND_REMOVE_CELL_LINKS
	}
	
	void	appendLabelItems(Menu &menu, BOOL bPrependSeparator = FALSE, BOOL bMultipleLabelRowsSelected = TRUE, BOOL bAppendDelete = FALSE)
	{
		/// CPY 1/20/07 QA70-9281 OC_RANGE_BASED_ACCESS_TO_LABEL_AREA
		menu.Add(_L("Please Wait..."), ID_DYN_XF_WKS_CM_LABELROWNUMS);
		/// end OC_RANGE_BASED_ACCESS_TO_LABEL_AREA
		
		if ( bPrependSeparator )
			menu.Add(NULL, 0, MF_SEPARATOR);
		/// TD 9-13-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
		if(bAppendDelete)
		{
			menu.Add(_L("Insert"), ID_WKSLAYERCTXT_INSERT_LABEL);
			menu.Add(_L("Delete"), ID_WKSLAYERCTXT_DELETE_SELECTION);
			menu.Add(_L("Clear"), ID_WKSLAYERCTXT_CLEAR_LABEL);
			menu.Add(NULL, 0, MF_SEPARATOR);
		}
		/// end WORKSHEET_CONTEXT_MORE_WORK

		if ( !bMultipleLabelRowsSelected )	// only Paramaters can be multiple
		{
			menu.Add(_L("Set As Long Name"), ID_WKSLAYERCTXT_SET_AS_LONG_NAME);
			/// TD 1-25-2008 QA80-10413  SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
			if(!bAppendDelete)
				menu.Add(_L("Set As Short Name"), ID_WKSLAYERCTXT_SET_AS_SHORT_NAME);
			/// end SET_AS_SHORT_NAMES_FOR_ROCHE_PHARMA
			menu.Add(_L("Set As Units"), ID_WKSLAYERCTXT_SET_AS_UNITS);
		}
		menu.Add(_L("Set As Comment"), ID_WKSLAYERCTXT_SET_AS_COMMENT);
		menu.Add(_L("Append To Comment"), ID_WKSLAYERCTXT_APPEND_TO_COMMENT);
		menu.Add(_L("Set As Parameters"), ID_WKSLAYERCTXT_SET_AS_PARAMETER);
		
		/// TD 9-13-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
		//if(bAppendDelete)
		//{
		//	menu.Add(NULL, 0, MF_SEPARATOR);
		//	menu.Add(_L("Delete"), ID_WKSLAYERCTXT_DELETE_SELECTION);
		//}
		/// end WORKSHEET_CONTEXT_MORE_WORK

		return;
	}

	bool oneColHeader(int nCol, int x, int y)
	{
		Worksheet wks = m_wks;
		if(nCol >= 0 && nCol < wks.GetNumCols())
		{
			Column cc = wks.Columns(nCol);
			//printf("Col(%s) is selected\n", cc.GetName());
			string strClassName = cc.GetEventHandler(true);
			if(!strClassName.IsEmpty())
			{
				OriginEventsBase& co = (OneColHeaderHandler&)Project.FindClass(strClassName);
				if(co)
				{
					//out_str("Found handler");
					/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
					// changing for consitency with Tarak's new code
					//	return co.DoContextMenu(cc, x, y, GetWindow());
					return co.SetObj(cc) && co.OnContextMenu(x, y);
					/// end CORNER_OBJECT_FOR_NEW_WORKBOOK
				}
			}
		}
		return false;
	}
	
	
	
};




//#define IDM_CM_HIDE_WKBOOK_ORGANIZER (OC_MENURANGE_BEGIN+21)

#define IDR_CM_COMMON							581
#define	ID_COMMON_TITLE							0

class OC_REGISTERED OWkBookEvents : public WkBookEventsBase
{
public:
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//bool OnContextMenu(int x, int y)
	bool OnContextMenu(int x, int y, DWORD dwControl = 0)
	/// end EVENT_HANDLING_ETC_FOR_OK 
	{
		Menu menu;
		/// TD 10-04-04 QA70-7000 GETNTREE_TO_GENERATE_POPUP_MENUS
		//Worksheet wks;
		//if(!GetWksheet(wks))
		//	return false;
		/// end GETNTREE_TO_GENERATE_POPUP_MENUS
		//if(!defaultMenu(menu, IDR_CM_WKS, ID_WKS_OUTSIDE))
		int nPos = (OBE_MENU_CORNER & dwControl) ? ID_WKS_CORNER : ID_WKS_OUTSIDE;
		if(!defaultMenu(menu, IDR_CM_WKS, nPos))
			return false;
				
		/// TD 10-04-04 QA70-7000 GETNTREE_TO_GENERATE_POPUP_MENUS
		//addOrganizer(menu);
		//
		//WksHeaderMenu SubMenu(wks, TRUE);
		//menu.InsertPopup(1, _L("View"), SubMenu, OC_MENURANGE_BEGIN);
		//int nCmd =	menu.TrackPopupResMenu(0,  x, y, GetWindow());
		//if(SubMenu.IsHandled())
		//	return true;
		/// SY 2007-04-11 QA70-9592 8.0599 RESULT_SHEET_CONTEXT_MENU
		///	int nCmd = addMenusAndPopups(x,y, menu);
		int nCmd = addMenusAndPopups(x,y, menu, nPos);
		/// end RESULT_SHEET_CONTEXT_MENU
		if(0  == nCmd)
			return true;
		/// end GETNTREE_TO_GENERATE_POPUP_MENUS
		
		if(IsOCProcess(nCmd) )
			return true;
		/*
		if(IDM_CM_HIDE_WKBOOK_ORGANIZER == nCmd)
		{
			LT_execute("page -sps"); 
			return true;
		}
		*/
		m_wksBook.ProcessCommand(nCmd);//CPY 5/26/04, cannot link so fix later
		return true;
	}
	//virtual 
	bool ProcessMenu(Menu& menu, int x, int y, int& nCmd)
	{
		nCmd =addMenusAndPopups(x,y, menu);
		if(0 == nCmd)
			return true;
		return IsOCProcess(nCmd);
	}
	bool OnPropsDiaolog(int x, int y)
	{
		Worksheet wksRhs;// = m_wksBook.Layers();
		///DG WKS_PROPERTIES_BY_DBCLICK
		if(!GetWksheet(wksRhs))
			ASSERT(0);
		///end WKS_PROPERTIES_BY_DBCLICK
		WksAccess wAccess(wksRhs);
		Tree tr;
		TreeNode tn = tr;
		wAccess.GetTree(tn);
		return wAccess.ShowDialog(tn, _L("Worksheet Properties"), _L("Properties"), GetWindow());
	}	
protected:
private:
	int insertTheme(Menu& menu, int nPos = 1)
	{
		Menu SubMenu;
		SubMenu.Add(_L("Colors"), IDM_CM_THEME_COPY_COLORS);
		SubMenu.Add(_L("Fonts"), IDM_CM_THEME_COPY_FONTS);
		SubMenu.Add(_L("All"), IDM_CM_THEME_COPY_ALL);
		menu.InsertMenu(nPos++, MF_BYPOSITION | MF_SEPARATOR);
		menu.InsertPopup(nPos++, _L("Copy Format"), SubMenu, OC_MENURANGE_BEGIN);
		menu.InsertMenu(nPos++, MF_BYPOSITION | (theme_is_in_clipboard()? 0:MF_DISABLED), IDM_CM_THEME_PASTE_FORMAT, _L("Paste Format"));
		//---- CPY 4/7/06 WKS_THEME_CHANGE_FROM_SAVE_TO_EDIT_FORMAT
		//menu.InsertMenu(nPos + 1, MF_BYPOSITION, IDM_CM_THEME_SAVE_FORMAT, _L("Save Format as Theme..."));
		//menu.InsertMenu(nPos + 2, MF_BYPOSITION, IDM_CM_THEME_SAVE_FORMAT, _L("Edit Formatting..."));
		if(isShowEditFormatDlg())//---- CPY 2/17/10 QA81-15124 HIDE_EDIT_FORMATTING_DLG
		InsertEditFormatting(menu, nPos++);
		//----
		return nPos
	}
	int addMenusAndPopups(int x, int y, Menu& menu, int nPos = 0, BOOL bAddView = TRUE)
	{		
		Worksheet wks;
		if(!GetWksheet(wks))
			return 0;
		
		/// SY 2007-04-11 QA70-9592 8.0599 RESULT_SHEET_CONTEXT_MENU
		if( ID_WKS_OUTSIDE == nPos && (wks.GetSystemParam(0) & WP_SHEET_HIERARCHY) )
		{
			////////////////////////////////////////////////
			// Note:
			// RemoveMenu by position which is NOT the best way.
			// If the resource (in OUSER.rc, menu IDR_CM_WKS - OutSide) is changed, 
			// here the position value also need change.
			////////////////////////////////////////////////
			// Remove unwanted menus for result sheet
			menu.RemoveMenu(3, MF_BYPOSITION); 	// Add New Column
			menu.RemoveMenu(6, MF_BYPOSITION);	// Go To...
			menu.RemoveMenu(6, MF_BYPOSITION);	// Separator
			menu.RemoveMenu(6, MF_BYPOSITION);	// Mask
			menu.RemoveMenu(6, MF_BYPOSITION);	// Separator
			menu.RemoveMenu(6, MF_BYPOSITION);	// Properties...
		}
		/// end RESULT_SHEET_CONTEXT_MENU
		
		WksHeaderMenu SubMenu(wks, TRUE);
		if(bAddView)
			menu.InsertPopup(nPos++, _L("View"), SubMenu, OC_MENURANGE_BEGIN);
		
		nPos = AddSideBars(menu, nPos, -1);
		nPos = insertTheme(menu, nPos);//--- CPY 2/15/05 WKS_THEME_SUPPORT
		
		menu.InsertMenu(nPos++, MF_BYPOSITION | MF_SEPARATOR);
		menu.InsertMenu(nPos++, MF_BYPOSITION, IDM_CM_ADD_SHEET, _L("Add New Sheet"));		

		
		int nCmd =	menu.TrackPopupResMenu(0,  x, y, GetWindow());
		
		if(bAddView)
		{
			SubMenu.Handler(nCmd);
			if(SubMenu.IsHandled())
				return 0;
		}
		return nCmd;
	}
private:
};
//=========================================================================
//=========================================================================
//---------------- CPY 7/22/06 QA70-8849 SHARE_WKBOOK_MATBOOK_ORGANIZER
class OC_REGISTERED OMatBookEvents : public WkBookEventsBase
{
public:
	bool OnContextMenu(int x, int y, DWORD dwControl = 0)
	{
		return WkBookEventsBase::OnContextMenu(x, y, dwControl);
	}
	//virtual 
	bool ProcessMenu(Menu& menu, int x, int y, int& nCmd)
	{
		nCmd =addMenusAndPopups(x,y, menu);
		if(0 == nCmd)
			return true;
		if(IDM_CM_SHOW_M_BAR == nCmd)
		{
			if(isMatBarShown())
				showMatBar(false);
			else
				showMatBar();					
			return true;
		}
		return IsOCProcess(nCmd);
	}
	bool OnPropsDiaolog(int x, int y)
	{
		return false;
	}	
protected:
private:
	int addMenusAndPopups(int x, int y, Menu& menu, int nPos = 0, BOOL bAddView = TRUE)
	{		
		nPos = AddSideBars(menu, nPos);
		//---- CPY 6/4/10 ORG-138-P6 SHOW_THUMBNAIL_TO_REPLACE_SCROLLBAR_CONTEXT_MENU
		//menu.InsertMenu(nPos++, MF_BYPOSITION | (isMatBarShown()?MF_CHECKED : 0), IDM_CM_SHOW_M_BAR, _L("Show Matrix Objects scroll bar"));
		//menu.InsertMenu(nPos++, MF_BYPOSITION | MF_SEPARATOR);
		//---- end SHOW_THUMBNAIL_TO_REPLACE_SCROLLBAR_CONTEXT_MENU
		///Jasmine 08/15/07 80_NOT_SUPPORT_MATRIX_THEME
		/*
		InsertEditFormatting(menu, nPos++); 
		menu.InsertMenu(nPos++, MF_BYPOSITION | MF_SEPARATOR);
		*/
		///End 80_NOT_SUPPORT_MATRIX_THEME
		int nCmd =	menu.TrackPopupResMenu(0,  x, y, GetWindow());
		return nCmd;
	}
};
//------------- end SHARE_WKBOOK_MATBOOK_ORGANIZER

//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE
class OC_REGISTERED GridEvents : public  OriginEventsBase
{
public:
	//virtual 
	bool OnContextMenu(int x, int y, DWORD dwControl = 0);
	bool SetObj(OriginObject &obj)
	{
		m_grid = obj;
		return true;
	}
	
	
private:	
	Grid m_grid;
};
//--------


//------ CPY 5/11/2007 QA70-9760 XFBAR_CONTEXT_MENU_ON_TITLE	
class OC_REGISTERED OGraphEvents : public PageLayerEventsBase
{
public:
	//virtual
	bool SetObj(OriginObject &obj)
	{
		m_gpg = obj;
		///Jasmine 07/23/07 SHOULD_USE_GRAPH_PAGE_BASE
		///Jasmine 07/13/07 LAYOUT_PAGE_IS_NOT_GRAPHPAGE
		//if(!m_gpg)
			//m_pg = obj;
		///End LAYOUT_PAGE_IS_NOT_GRAPHPAGE
		///End SHOULD_USE_GRAPH_PAGE_BASE
		return true;
	}
	//virtual 
	///Jasmine 07/23/07 SHOULD_USE_GRAPH_PAGE_BASE
	OriginObject& GetObj() {return m_gpg;}
	//{
		///Jasmine 07/13/07 LAYOUT_PAGE_IS_NOT_GRAPHPAGE
		//if(m_gpg)
			//return m_gpg;
		//return m_pg;
		///End LAYOUT_PAGE_IS_NOT_GRAPHPAGE
	//}
	///End SHOULD_USE_GRAPH_PAGE_BASE
	Page& GetPage() {return m_gpg;}
	//virtual 
	bool ProcessMenu(Menu& menu, int x, int y, int& nCmd)
	{
		///Jasmine 07/23/07 NOT_SHOW_SCRIPT_PANEL_IN_LAYOUT_BY_KITKIT_REQUEST
		int nType = m_gpg? m_gpg.GetType() : EXIST_NONE;
		bool bAddScriptPanel = EXIST_PLOT == nType;
		int nPos =0;
		nPos = AddSideBars(menu, nPos, bAddScriptPanel ? 1 : 0, false, bAddScriptPanel);	
		///End NOT_SHOW_SCRIPT_PANEL_IN_LAYOUT_BY_KITKIT_REQUEST
		nCmd =	menu.TrackPopupResMenu(0,  x, y, GetWindow());
		if(0 == nCmd)
			return true;
		return IsOCProcess(nCmd);
	}
private:
	//GraphPage 	m_gpg;
	GraphPageBase 	m_gpg;	///Jasmine 07/23/07 SHOULD_USE_GRAPH_PAGE_BASE
	//Page  		m_pg;
};
//------ end XFBAR_CONTEXT_MENU_ON_TITLE


#endif//_WKSEVENTS_H_




